/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http;

import com.alibaba.arthas.deps.io.netty.channel.ChannelFuture;
import com.alibaba.arthas.deps.io.netty.channel.ChannelFutureListener;
import com.alibaba.arthas.deps.io.netty.channel.ChannelHandlerContext;
import com.alibaba.arthas.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpResponse;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpResponseStatus;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpUtil;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpVersion;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.LastHttpContent;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.IOUtils;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.term.impl.http.DirectoryBrowser;
import com.taobao.arthas.core.shell.term.impl.http.api.HttpApiHandler;
import com.taobao.arthas.core.util.HttpUtils;
import io.termd.core.http.HttpTtyConnection;
import io.termd.core.util.Logging;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestHandler.class);
    private final String wsUri;
    private File dir;
    private HttpApiHandler httpApiHandler;

    public HttpRequestHandler(String wsUri) {
        this(wsUri, ArthasBootstrap.getInstance().getOutputPath());
    }

    public HttpRequestHandler(String wsUri, File dir) {
        this.wsUri = wsUri;
        this.dir = dir;
        dir.mkdirs();
        this.httpApiHandler = ArthasBootstrap.getInstance().getHttpApiHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        boolean isFileResponseFinished;
        boolean isHttpApiResponse;
        HttpResponse response;
        block14: {
            String path = new URI(request.uri()).getPath();
            if (this.wsUri.equalsIgnoreCase(path)) {
                ctx.fireChannelRead(request.retain());
                return;
            }
            if (HttpUtil.is100ContinueExpected(request)) {
                HttpRequestHandler.send100Continue(ctx);
            }
            response = null;
            if ("/".equals(path)) {
                path = "/index.html";
            }
            isHttpApiResponse = false;
            isFileResponseFinished = false;
            try {
                if ("/api".equals(path)) {
                    response = this.httpApiHandler.handle(ctx, request);
                    isHttpApiResponse = true;
                }
                if (path.equals("/ui")) {
                    response = HttpUtils.createRedirectResponse(request, "/ui/");
                }
                if (path.equals("/ui/")) {
                    path = path + "index.html";
                }
                if (response == null) {
                    response = this.readFileFromResource(request, path);
                }
                if (response == null) {
                    response = DirectoryBrowser.directView(this.dir, path, request, ctx);
                    boolean bl = isFileResponseFinished = response != null;
                }
                if (response == null) {
                    response = HttpUtils.createResponse(request, HttpResponseStatus.NOT_FOUND, "Not found");
                }
                if (response != null) break block14;
            }
            catch (Throwable e) {
                block15: {
                    try {
                        logger.error("arthas process http request error: " + request.uri(), e);
                        if (response != null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (response == null) {
                            response = HttpUtils.createResponse(request, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Server error");
                        }
                        if (isFileResponseFinished) throw throwable;
                        ChannelFuture future = this.writeResponse(ctx, response);
                        future.addListener(ChannelFutureListener.CLOSE);
                        if (!isHttpApiResponse || !(response instanceof DefaultFullHttpResponse)) throw throwable;
                        HttpResponse finalResponse = response;
                        future.addListener(new ChannelFutureListener(finalResponse){
                            final /* synthetic */ HttpResponse val$finalResponse;
                            {
                                this.val$finalResponse = httpResponse;
                            }

                            @Override
                            public void operationComplete(ChannelFuture future) throws Exception {
                                HttpRequestHandler.this.httpApiHandler.onCompleted((DefaultFullHttpResponse)this.val$finalResponse);
                            }
                        });
                        throw throwable;
                    }
                    response = HttpUtils.createResponse(request, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Server error");
                }
                if (isFileResponseFinished) return;
                ChannelFuture future = this.writeResponse(ctx, response);
                future.addListener(ChannelFutureListener.CLOSE);
                if (!isHttpApiResponse || !(response instanceof DefaultFullHttpResponse)) return;
                HttpResponse finalResponse = response;
                future.addListener(new /* invalid duplicate definition of identical inner class */);
                return;
            }
            response = HttpUtils.createResponse(request, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Server error");
        }
        if (isFileResponseFinished) return;
        ChannelFuture future = this.writeResponse(ctx, response);
        future.addListener(ChannelFutureListener.CLOSE);
        if (!isHttpApiResponse || !(response instanceof DefaultFullHttpResponse)) return;
        HttpResponse finalResponse = response;
        future.addListener(new /* invalid duplicate definition of identical inner class */);
        return;
    }

    private ChannelFuture writeResponse(ChannelHandlerContext ctx, HttpResponse response) {
        if (!HttpUtil.isTransferEncodingChunked(response) && response instanceof DefaultFullHttpResponse) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)((DefaultFullHttpResponse)response).content().readableBytes());
            return ctx.writeAndFlush(response);
        }
        ctx.write(response);
        return ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse readFileFromResource(FullHttpRequest request, String path) throws IOException {
        DefaultFullHttpResponse fullResp = null;
        InputStream in = null;
        try {
            URL res = HttpTtyConnection.class.getResource("/com/taobao/arthas/core/http" + path);
            if (res != null) {
                String ext;
                String contentType;
                fullResp = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.OK);
                in = res.openStream();
                byte[] tmp = new byte[256];
                int l = 0;
                while (l != -1) {
                    fullResp.content().writeBytes(tmp, 0, l);
                    l = in.read(tmp);
                }
                int li = path.lastIndexOf(46);
                if (li != -1 && li != path.length() - 1 && (contentType = "html".equals(ext = path.substring(li + 1)) ? "text/html" : ("js".equals(ext) ? "application/javascript" : ("css".equals(ext) ? "text/css" : null))) != null) {
                    fullResp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
                }
            }
        }
        finally {
            IOUtils.close(in);
        }
        return fullResp;
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.writeAndFlush(response);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Logging.logReportedIoError(cause);
        ctx.close();
    }
}

